// Copyright 2015 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// Based on: Olivier Gillet (ol.gillet@gmail.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Global clock.

#include "midialf/clock.h"

#include "midialf/resources.h"

namespace midialf {

Clock clock;

/* <static> */
uint32_t Clock::clock_;
uint16_t Clock::tick_count_;
uint16_t Clock::tick_count_limit_;
uint16_t Clock::intervals_[2];
uint16_t Clock::interval_;
uint8_t Clock::off_beat_;
uint8_t Clock::running_;
/* </static> */

/* static */
void Clock::Update(uint16_t bpm, uint8_t bpm_tenth, int16_t swing) {
  int32_t base_tick_duration = 7812500 / (static_cast<uint32_t>(bpm) * 10 + bpm_tenth) - 1;

  int16_t swing_amount = swing - kNoSwing;
  if (swing_amount) {
    int32_t swing_delta = base_tick_duration * swing_amount / kNoSwing;
    intervals_[0] = base_tick_duration - swing_delta;
    intervals_[1] = base_tick_duration + swing_delta;
  } else {
    intervals_[0] = base_tick_duration;
    intervals_[1] = base_tick_duration;
  }
}

}  // namespace midialf
