// Copyright 2018 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Step condition routines.

#ifndef MIDIALF_COND_H_
#define MIDIALF_COND_H_

#include "avrlib/base.h"

namespace midialf {

static const uint8_t kNumRandomConditions = 21;
static const uint8_t kNumAbConditions = 35;
static const uint8_t kNumAbConditionGroups = 7;

enum Conditions {
  hasShift, noShift,
  hasPrevious, noPrevious,
  isFirst, notFirst,
  abFirst, 
  abLast = abFirst + kNumAbConditions - 1,
  random1, 
  random99 = random1 + kNumRandomConditions - 1,
  kNumConditions
};

static const uint8_t kMinCondition = 0;
static const uint8_t kMaxCondition = kNumConditions - 1;
static const uint8_t kDefCondition = 0;

enum ConditionTarget {
  noteCondition,
  cc1Condition,
  cc2Condition,
  retriggerCondition,
  kNumConditionTargets
};

class Cond {
 public:
  Cond() {}

  static void Init();

  static uint8_t CheckCondition(uint8_t condition, uint8_t condition_target);

  static void get_name(uint8_t condition, char buffer[4]);

  static uint16_t step_count() { return step_count_; }
  static uint16_t play_count() { return play_count_; }

private:
  static uint16_t step_count_;
  static uint16_t play_count_;
  static uint8_t last_result_[kNumConditionTargets];

  static uint8_t Evaluate(uint8_t condition, uint8_t last_result);

  static uint8_t IsFirst();
  static void ClearResults();

  static uint8_t get_ab(uint8_t condition, uint8_t& a, uint8_t& b);
  static uint8_t get_random(uint8_t condition, uint8_t& percent);

  static void RunningCallback();
  static void StepCallback();

  DISALLOW_COPY_AND_ASSIGN(Cond);
};

extern Cond cond;

}  // namespace midialf

#endif // MIDIALF_COND_H_
