// Copyright 2011 Olivier Gillet.
//
// Author: Olivier Gillet (ol.gillet@gmail.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Resources definitions.
//
// Automatically generated with:
// make resources


#include "midialf\resources.h"

namespace midialf {

static const prog_char str_res_x[] PROGMEM = "x";


PROGMEM const prog_char* const string_table[] = {
  str_res_x,
};

const prog_uint16_t lut_res_lfo_increments[] PROGMEM = {
     170,    227,    341,    455,    682,    910,   1024,   1365,
    1820,   2048,   2730,   4096,   5461,   8192,  10922,  16384,
   21845,  32768,  65535,
};


PROGMEM const prog_uint16_t* const lookup_table_table[] = {
  lut_res_lfo_increments,
};

const prog_uint8_t lut_res_curve_soft1[] PROGMEM = {
       0,      1,      3,      5,      7,      8,     10,     12,
      13,     15,     17,     18,     20,     21,     23,     24,
      26,     27,     29,     30,     32,     33,     35,     36,
      38,     39,     40,     42,     43,     44,     46,     47,
      48,     49,     51,     52,     53,     54,     56,     57,
      58,     59,     60,     61,     63,     64,     65,     66,
      67,     68,     69,     70,     71,     72,     73,     74,
      75,     76,     77,     78,     79,     80,     81,     82,
      82,     83,     84,     85,     86,     87,     88,     89,
      89,     90,     91,     92,     93,     93,     94,     95,
      96,     97,     97,     98,     99,     99,    100,    101,
     102,    102,    103,    104,    104,    105,    106,    107,
     107,    108,    109,    109,    110,    110,    111,    112,
     112,    113,    114,    114,    115,    116,    116,    117,
     117,    118,    119,    119,    120,    120,    121,    122,
     122,    123,    124,    124,    125,    125,    126,    127,
};
const prog_uint8_t lut_res_curve_soft2[] PROGMEM = {
       0,      2,      5,      7,     10,     12,     15,     17,
      19,     22,     24,     26,     28,     30,     32,     34,
      36,     38,     40,     42,     44,     46,     48,     49,
      51,     53,     54,     56,     57,     59,     60,     62,
      63,     65,     66,     67,     69,     70,     71,     72,
      74,     75,     76,     77,     78,     79,     80,     81,
      82,     83,     84,     85,     86,     87,     88,     88,
      89,     90,     91,     92,     92,     93,     94,     94,
      95,     96,     96,     97,     98,     98,     99,     99,
     100,    100,    101,    102,    102,    103,    103,    103,
     104,    104,    105,    105,    106,    106,    107,    107,
     108,    108,    108,    109,    109,    110,    110,    111,
     111,    111,    112,    112,    113,    113,    113,    114,
     114,    115,    115,    116,    116,    117,    117,    118,
     118,    118,    119,    119,    120,    121,    121,    122,
     122,    123,    123,    124,    125,    125,    126,    127,
};
const prog_uint8_t lut_res_curve_soft3[] PROGMEM = {
       0,      1,      2,      3,      4,      5,      6,      7,
       8,      9,     10,     11,     13,     14,     15,     16,
      17,     19,     20,     21,     22,     24,     25,     26,
      27,     29,     30,     31,     33,     34,     35,     36,
      38,     39,     40,     42,     43,     44,     46,     47,
      48,     50,     51,     53,     54,     55,     57,     58,
      59,     61,     62,     63,     65,     66,     67,     69,
      70,     71,     72,     74,     75,     76,     78,     79,
      80,     81,     83,     84,     85,     86,     88,     89,
      90,     91,     92,     93,     95,     96,     97,     98,
      99,    100,    101,    102,    103,    104,    105,    106,
     107,    108,    109,    110,    111,    111,    112,    113,
     114,    115,    115,    116,    117,    118,    118,    119,
     120,    120,    121,    121,    122,    122,    123,    123,
     124,    124,    124,    125,    125,    125,    126,    126,
     126,    126,    126,    126,    126,    126,    127,    126,
};
const prog_uint8_t lut_res_curve_hard1[] PROGMEM = {
       0,      0,      1,      1,      2,      2,      3,      4,
       4,      5,      6,      6,      7,      7,      8,      9,
       9,     10,     10,     11,     12,     12,     13,     14,
      14,     15,     16,     16,     17,     17,     18,     19,
      19,     20,     21,     22,     22,     23,     24,     24,
      25,     26,     27,     27,     28,     29,     29,     30,
      31,     32,     33,     33,     34,     35,     36,     37,
      37,     38,     39,     40,     41,     42,     43,     44,
      44,     45,     46,     47,     48,     49,     50,     51,
      52,     53,     54,     55,     56,     57,     58,     59,
      60,     61,     62,     63,     65,     66,     67,     68,
      69,     70,     72,     73,     74,     75,     77,     78,
      79,     80,     82,     83,     84,     86,     87,     88,
      90,     91,     93,     94,     96,     97,     99,    100,
     102,    103,    105,    106,    108,    109,    111,    113,
     114,    116,    118,    119,    121,    123,    125,    127,
};
const prog_uint8_t lut_res_curve_hard2[] PROGMEM = {
       0,      0,      1,      1,      2,      3,      3,      4,
       4,      5,      5,      6,      7,      7,      8,      8,
       8,      9,      9,     10,     10,     11,     11,     12,
      12,     13,     13,     13,     14,     14,     15,     15,
      15,     16,     16,     17,     17,     18,     18,     18,
      19,     19,     20,     20,     21,     21,     22,     22,
      23,     23,     23,     24,     24,     25,     26,     26,
      27,     27,     28,     28,     29,     30,     30,     31,
      32,     32,     33,     34,     34,     35,     36,     37,
      38,     38,     39,     40,     41,     42,     43,     44,
      45,     46,     47,     48,     49,     50,     51,     52,
      54,     55,     56,     57,     59,     60,     61,     63,
      64,     66,     67,     69,     70,     72,     73,     75,
      77,     78,     80,     82,     84,     86,     88,     90,
      92,     94,     96,     98,    100,    102,    104,    107,
     109,    111,    114,    116,    119,    121,    124,    127,
};
const prog_uint8_t lut_res_curve_hard3[] PROGMEM = {
       0,      0,      0,      0,      0,      0,      0,      0,
       0,      0,      1,      1,      1,      2,      2,      2,
       3,      3,      4,      4,      5,      5,      6,      6,
       7,      8,      8,      9,     10,     11,     11,     12,
      13,     14,     15,     15,     16,     17,     18,     19,
      20,     21,     22,     23,     24,     25,     26,     27,
      28,     29,     30,     31,     33,     34,     35,     36,
      37,     38,     40,     41,     42,     43,     45,     46,
      47,     48,     50,     51,     52,     54,     55,     56,
      57,     59,     60,     61,     63,     64,     65,     67,
      68,     69,     71,     72,     73,     75,     76,     78,
      79,     80,     82,     83,     84,     86,     87,     88,
      90,     91,     92,     93,     95,     96,     97,     99,
     100,    101,    102,    104,    105,    106,    107,    109,
     110,    111,    112,    113,    115,    116,    117,    118,
     119,    120,    121,    122,    123,    124,    125,    127,
};
const prog_uint8_t lut_res_curve_wide1[] PROGMEM = {
       0,      2,      4,      5,      7,      9,     11,     13,
      14,     16,     18,     19,     21,     22,     24,     25,
      27,     28,     29,     31,     32,     33,     34,     35,
      36,     37,     39,     40,     41,     41,     42,     43,
      44,     45,     46,     47,     47,     48,     49,     50,
      50,     51,     52,     52,     53,     54,     54,     55,
      55,     56,     56,     57,     57,     58,     58,     59,
      59,     60,     60,     61,     61,     62,     62,     63,
      63,     64,     64,     65,     65,     66,     66,     67,
      67,     68,     68,     69,     69,     70,     70,     71,
      71,     72,     72,     73,     74,     74,     75,     76,
      76,     77,     78,     79,     79,     80,     81,     82,
      83,     84,     85,     85,     86,     87,     89,     90,
      91,     92,     93,     94,     95,     97,     98,     99,
     101,    102,    104,    105,    107,    108,    110,    112,
     113,    115,    117,    119,    121,    122,    124,    127,
};
const prog_uint8_t lut_res_curve_wide2[] PROGMEM = {
       0,      2,      4,      7,      9,     11,     13,     15,
      17,     19,     21,     23,     24,     26,     28,     29,
      31,     32,     34,     35,     36,     38,     39,     40,
      41,     42,     43,     44,     45,     46,     47,     48,
      49,     50,     50,     51,     52,     53,     53,     54,
      54,     55,     55,     56,     56,     57,     57,     58,
      58,     59,     59,     59,     60,     60,     60,     61,
      61,     61,     61,     62,     62,     62,     63,     63,
      63,     63,     64,     64,     64,     65,     65,     65,
      65,     66,     66,     66,     67,     67,     67,     68,
      68,     69,     69,     70,     70,     71,     71,     72,
      72,     73,     73,     74,     75,     76,     76,     77,
      78,     79,     80,     81,     82,     83,     84,     85,
      86,     87,     88,     90,     91,     92,     94,     95,
      97,     98,    100,    102,    103,    105,    107,    109,
     111,    113,    115,    117,    119,    122,    124,    127,
};


const prog_uint8_t* const lookup_table_8_table[] = {
  lut_res_curve_soft1,
  lut_res_curve_soft2,
  lut_res_curve_soft3,
  lut_res_curve_hard1,
  lut_res_curve_hard2,
  lut_res_curve_hard3,
  lut_res_curve_wide1,
  lut_res_curve_wide2,
};

const prog_uint8_t chr_res_custom_chars[] PROGMEM = {
      24,     16,     24,      0,      0,      0,      0,      0,
       0,      0,      0,      0,     28,      8,      8,      0,
      24,     16,     24,      0,     28,      8,      8,      0,
       0,     10,     17,     21,     17,     10,      0,      0,
};


const prog_uint8_t* const character_table[] = {
  chr_res_custom_chars,
};

const prog_uint8_t wav_res_lfo_waveforms[] PROGMEM = {
       1,      5,      9,     13,     17,     21,     25,     29,
      33,     37,     41,     44,     48,     52,     56,     60,
      64,     68,     72,     76,     80,     84,     88,     92,
      96,    100,    104,    108,    112,    116,    120,    124,
     128,    131,    135,    139,    143,    147,    151,    155,
     159,    163,    167,    171,    175,    179,    183,    187,
     191,    195,    199,    203,    207,    211,    214,    218,
     222,    226,    230,    234,    238,    242,    246,    250,
     254,    250,    246,    242,    238,    234,    230,    226,
     222,    218,    214,    211,    207,    203,    199,    195,
     191,    187,    183,    179,    175,    171,    167,    163,
     159,    155,    151,    147,    143,    139,    135,    131,
     128,    124,    120,    116,    112,    108,    104,    100,
      96,     92,     88,     84,     80,     76,     72,     68,
      64,     60,     56,     52,     48,     44,     41,     37,
      33,     29,     25,     21,     17,     13,      9,      5,
       1,    254,    254,    254,    254,    254,    254,    254,
     254,    254,    254,    254,    254,    254,    254,    254,
     254,    254,    254,    254,    254,    254,    254,    254,
     254,    254,    254,    254,    254,    254,    254,    254,
     254,    254,    254,    254,    254,    254,    254,    254,
     254,    254,    254,    254,    254,    254,    254,    254,
     254,    254,    254,    254,    254,    254,    254,    254,
     254,    254,    254,    254,    254,    254,    254,    254,
     254,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,    254,      1,      3,      5,      7,      9,     11,
      13,     15,     17,     19,     21,     23,     25,     27,
      29,     31,     33,     35,     37,     39,     41,     43,
      45,     47,     49,     51,     53,     55,     57,     59,
      61,     63,     65,     67,     69,     71,     73,     75,
      77,     79,     81,     83,     85,     87,     89,     91,
      93,     95,     97,     99,    101,    103,    105,    107,
     109,    111,    113,    115,    117,    119,    121,    123,
     125,    127,    128,    130,    132,    134,    136,    138,
     140,    142,    144,    146,    148,    150,    152,    154,
     156,    158,    160,    162,    164,    166,    168,    170,
     172,    174,    176,    178,    180,    182,    184,    186,
     188,    190,    192,    194,    196,    198,    200,    202,
     204,    206,    208,    210,    212,    214,    216,    218,
     220,    222,    224,    226,    228,    230,    232,    234,
     236,    238,    240,    242,    244,    246,    248,    250,
     252,    254,      1,    128,    134,    140,    146,    152,
     158,    164,    170,    176,    182,    187,    193,    198,
     203,    208,    212,    217,    221,    225,    229,    233,
     236,    239,    242,    244,    247,    249,    250,    252,
     253,    253,    254,    254,    254,    253,    253,    252,
     250,    249,    247,    244,    242,    239,    236,    233,
     229,    225,    221,    217,    212,    208,    203,    198,
     193,    187,    182,    176,    170,    164,    158,    152,
     146,    140,    134,    128,    121,    115,    109,    103,
      97,     91,     85,     79,     73,     68,     62,     57,
      52,     47,     43,     38,     34,     30,     26,     22,
      19,     16,     13,     11,      8,      6,      5,      3,
       2,      2,      1,      1,      1,      2,      2,      3,
       5,      6,      8,     11,     13,     16,     19,     22,
      26,     30,     34,     38,     43,     47,     52,     57,
      62,     68,     73,     79,     85,     91,     97,    103,
     109,    115,    121,    128,    128,    138,    148,    157,
     167,    177,    186,    194,    203,    210,    218,    224,
     230,    236,    241,    245,    248,    251,    252,    254,
     254,    254,    253,    251,    249,    246,    243,    239,
     234,    230,    224,    219,    213,    207,    201,    195,
     189,    182,    176,    170,    164,    159,    153,    148,
     143,    139,    135,    131,    128,    125,    123,    121,
     120,    119,    118,    118,    118,    118,    119,    120,
     121,    123,    124,    126,    128,    129,    131,    132,
     134,    135,    136,    137,    137,    137,    137,    136,
     135,    134,    132,    130,    127,    124,    120,    116,
     112,    107,    102,     96,     91,     85,     79,     73,
      66,     60,     54,     48,     42,     36,     31,     25,
      21,     16,     12,      9,      6,      4,      2,      1,
       1,      1,      3,      4,      7,     10,     14,     19,
      25,     31,     37,     45,     52,     61,     69,     78,
      88,     98,    107,    117,    128,    128,    143,    158,
     172,    186,    199,    211,    222,    231,    239,    245,
     250,    253,    254,    254,    252,    249,    244,    239,
     232,    225,    217,    209,    201,    194,    186,    179,
     173,    168,    163,    160,    158,    158,    158,    160,
     163,    168,    173,    179,    186,    194,    201,    209,
     217,    225,    232,    239,    244,    249,    252,    254,
     254,    253,    250,    245,    239,    231,    222,    211,
     199,    186,    172,    158,    143,    128,    112,     97,
      83,     69,     56,     44,     33,     24,     16,     10,
       5,      2,      1,      1,      3,      6,     11,     16,
      23,     30,     38,     46,     54,     61,     69,     76,
      82,     87,     92,     95,     97,     97,     97,     95,
      92,     87,     82,     76,     69,     61,     54,     46,
      38,     30,     23,     16,     11,      6,      3,      1,
       1,      2,      5,     10,     16,     24,     33,     44,
      56,     69,     83,     97,    112,    128,    128,    144,
     159,    173,    185,    195,    201,    204,    204,    201,
     196,    188,    179,    169,    160,    151,    143,    138,
     135,    135,    138,    144,    153,    164,    176,    190,
     204,    217,    229,    240,    247,    252,    254,    252,
     247,    240,    229,    217,    204,    190,    176,    164,
     153,    144,    138,    135,    135,    138,    143,    151,
     160,    169,    179,    188,    196,    201,    204,    204,
     201,    195,    185,    173,    159,    144,    128,    111,
      96,     82,     70,     60,     54,     51,     51,     54,
      59,     67,     76,     86,     95,    104,    112,    117,
     120,    120,    117,    111,    102,     91,     79,     65,
      51,     38,     26,     15,      8,      3,      1,      3,
       8,     15,     26,     38,     51,     65,     79,     91,
     102,    111,    117,    120,    120,    117,    112,    104,
      95,     86,     76,     67,     59,     54,     51,     51,
      54,     60,     70,     82,     96,    111,    128,      1,
       1,      1,      3,      5,      8,     13,     19,     27,
      37,     49,     62,     77,     93,    110,    128,    145,
     163,    180,    196,    211,    224,    235,    243,    250,
     253,    254,    252,    248,    241,    231,    220,    206,
     191,    176,    159,    142,    125,    108,     92,     76,
      62,     49,     37,     27,     19,     12,      6,      2,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      2,      2,      3,      3,      4,
       5,      6,      7,      7,      6,      5,      3,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      2,      5,      9,     17,     27,     41,
      58,     77,     99,    122,    146,    169,    191,    211,
     228,    241,    250,    254,    254,    249,    240,    227,
     212,    196,    178,    161,    146,    133,    123,    116,
     114,    116,    123,    133,    146,    161,    178,    196,
     212,    227,    240,    249,    254,    254,    250,    241,
     228,    211,    191,    169,    146,    122,     99,     77,
      58,     41,     27,     17,      9,      5,      2,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,      1,      1,      1,      1,      1,      1,      1,
       1,     63,     57,     51,     45,     39,     33,     27,
      21,     15,      9,      3,      1,      7,     13,     19,
      25,     31,     37,     43,     49,     55,     61,     67,
      73,     79,     85,     91,     97,    103,    109,    115,
     121,    128,    134,    140,    146,    152,    158,    164,
     170,    176,    182,    188,    194,    200,    206,    212,
     218,    224,    230,    236,    242,    248,    254,    252,
     246,    240,    234,    228,    222,    216,    210,    204,
     198,    192,    198,    204,    210,    216,    222,    228,
     234,    240,    246,    252,    254,    248,    242,    236,
     230,    224,    218,    212,    206,    200,    194,    188,
     182,    176,    170,    164,    158,    152,    146,    140,
     134,    128,    121,    115,    109,    103,     97,     91,
      85,     79,     73,     67,     61,     55,     49,     43,
      37,     31,     25,     19,     13,      7,      1,      3,
       9,     15,     21,     27,     33,     39,     45,     51,
      57,     63,    128,    120,    112,    104,     96,     88,
      80,     72,     64,     56,     48,     41,     33,     25,
      17,      9,      1,      9,     17,     25,     33,     41,
      48,     56,     64,     72,     80,     88,     96,    104,
     112,    120,    128,    135,    143,    151,    159,    167,
     175,    183,    191,    199,    207,    214,    222,    230,
     238,    246,    254,    246,    238,    230,    222,    214,
     207,    199,    191,    183,    175,    167,    159,    151,
     143,    135,    128,    135,    143,    151,    159,    167,
     175,    183,    191,    199,    207,    214,    222,    230,
     238,    246,    254,    246,    238,    230,    222,    214,
     207,    199,    191,    183,    175,    167,    159,    151,
     143,    135,    128,    120,    112,    104,     96,     88,
      80,     72,     64,     56,     48,     41,     33,     25,
      17,      9,      1,      9,     17,     25,     33,     41,
      48,     56,     64,     72,     80,     88,     96,    104,
     112,    120,    128,      1,      2,      3,      3,      4,
       5,      6,      7,      8,      9,     10,     11,     12,
      14,     15,     16,     18,     19,     21,     23,     24,
      26,     28,     30,     32,     34,     36,     38,     41,
      43,     46,     49,     52,     55,     58,     61,     64,
      68,     72,     76,     80,     84,     88,     93,     98,
     103,    108,    113,    119,    125,    131,    138,    145,
     152,    159,    167,    175,    183,    192,    201,    211,
     221,    232,    243,    254,    243,    232,    221,    211,
     201,    192,    183,    175,    167,    159,    152,    145,
     138,    131,    125,    119,    113,    108,    103,     98,
      93,     88,     84,     80,     76,     72,     68,     64,
      61,     58,     55,     52,     49,     46,     43,     41,
      38,     36,     34,     32,     30,     28,     26,     24,
      23,     21,     19,     18,     16,     15,     14,     12,
      11,     10,      9,      8,      7,      6,      5,      4,
       3,      3,      2,      1,      1,     12,     22,     32,
      41,     48,     56,     62,     68,     74,     79,     84,
      88,     92,     96,     99,    102,    105,    108,    110,
     112,    114,    116,    118,    119,    120,    122,    123,
     124,    125,    126,    127,    128,    128,    129,    130,
     131,    132,    133,    135,    136,    137,    139,    141,
     143,    145,    147,    150,    153,    156,    159,    163,
     167,    171,    176,    181,    187,    193,    199,    207,
     214,    223,    233,    243,    254,    243,    233,    223,
     214,    207,    199,    193,    187,    181,    176,    171,
     167,    163,    159,    156,    153,    150,    147,    145,
     143,    141,    139,    137,    136,    135,    133,    132,
     131,    130,    129,    128,    128,    127,    126,    125,
     124,    123,    122,    120,    119,    118,    116,    114,
     112,    110,    108,    105,    102,     99,     96,     92,
      88,     84,     79,     74,     68,     62,     56,     48,
      41,     32,     22,     12,      1,    229,    205,    184,
     164,    147,    130,    116,    102,     90,     79,     69,
      60,     51,     44,     38,     32,     26,     22,     18,
      14,     11,      9,      7,      5,      4,      2,      2,
       1,      1,      1,      1,      2,      2,      3,      4,
       5,      6,      8,      9,     11,     13,     14,     16,
      18,     20,     22,     25,     27,     29,     31,     34,
      36,     39,     41,     44,     46,     49,     51,     54,
      57,     59,     62,     65,     68,     70,     73,     76,
      79,     82,     84,     87,     90,     93,     96,     99,
     102,    104,    107,    110,    113,    116,    119,    122,
     125,    128,    130,    133,    136,    139,    142,    145,
     148,    151,    154,    157,    160,    163,    166,    169,
     171,    174,    177,    180,    183,    186,    189,    192,
     195,    198,    201,    204,    207,    210,    213,    216,
     219,    222,    225,    227,    230,    233,    236,    239,
     242,    245,    248,    251,    254,    229,     20,     38,
      54,     69,     83,     96,    108,    119,    130,    139,
     148,    156,    163,    170,    177,    183,    188,    193,
     198,    202,    206,    210,    213,    217,    220,    222,
     225,    227,    229,    231,    233,    235,    236,    238,
     239,    240,    242,    243,    244,    245,    245,    246,
     247,    248,    248,    249,    249,    250,    250,    251,
     251,    251,    252,    252,    252,    253,    253,    253,
     253,    253,    254,    254,    254,    254,    235,    217,
     201,    186,    172,    159,    147,    136,    125,    116,
     107,     99,     92,     85,     78,     72,     67,     62,
      57,     53,     49,     45,     42,     38,     35,     33,
      30,     28,     26,     24,     22,     20,     19,     17,
      16,     15,     13,     12,     11,     10,     10,      9,
       8,      7,      7,      6,      6,      5,      5,      4,
       4,      4,      3,      3,      3,      2,      2,      2,
       2,      2,      1,      1,      1,      1,     20,    254,
     230,    189,    139,     88,     45,     15,      1,      2,
      17,     41,     70,     99,    124,    142,    152,    153,
     148,    137,    123,    110,     98,     91,     88,     89,
      94,    102,    111,    121,    129,    135,    139,    140,
     139,    137,    134,    131,    129,    128,    128,    129,
     131,    135,    138,    142,    145,    148,    150,    151,
     152,    152,    152,    153,    153,    153,    154,    156,
     157,    159,    161,    163,    165,    167,    168,    170,
     171,    172,    173,    174,    175,    176,    177,    179,
     180,    182,    183,    185,    186,    188,    189,    190,
     192,    193,    194,    195,    197,    198,    199,    200,
     202,    203,    205,    206,    207,    209,    210,    211,
     213,    214,    215,    217,    218,    219,    221,    222,
     223,    225,    226,    227,    229,    230,    231,    233,
     234,    235,    237,    238,    239,    241,    242,    243,
     245,    246,    247,    249,    250,    251,    253,    254,
      67,     85,    115,    152,    189,    221,    243,    254,
     254,    244,    228,    208,    189,    172,    160,    154,
     154,    159,    168,    178,    189,    198,    204,    207,
     207,    205,    200,    194,    189,    184,    181,    179,
     179,    180,    183,    186,    189,    191,    193,    194,
     194,    193,    192,    190,    189,    187,    186,    186,
     186,    186,    187,    188,    189,    190,    190,    190,
     190,    190,    190,    189,    189,    188,    188,    188,
     188,    170,    140,    103,     66,     34,     12,      1,
       1,     11,     27,     47,     66,     83,     95,    101,
     101,     96,     87,     77,     66,     57,     51,     48,
      48,     50,     55,     61,     66,     71,     74,     76,
      76,     75,     72,     69,     66,     64,     62,     61,
      61,     62,     63,     65,     66,     68,     69,     69,
      69,     69,     68,     67,     66,     65,     65,     65,
      65,     65,     65,     66,     66,     67,     67,     67,
      67,
};


const prog_uint8_t* const waveform_table[] = {
  wav_res_lfo_waveforms,
};


}  // namespace midialf
