// Copyright 2011 Olivier Gillet.
//
// Author: Olivier Gillet (ol.gillet@gmail.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Resources definitions.
//
// Automatically generated with:
// make resources


#ifndef MIDIALF_RESOURCES_H_
#define MIDIALF_RESOURCES_H_


#include "avrlib/base.h"

#include <avr/pgmspace.h>


#include "avrlib/resources_manager.h"

namespace midialf {

typedef uint8_t ResourceId;

extern const prog_char* const string_table[];

extern const prog_uint16_t* const lookup_table_table[];

extern const prog_uint8_t* const lookup_table_8_table[];

extern const prog_uint8_t* const character_table[];

extern const prog_uint8_t* const waveform_table[];

extern const prog_uint16_t lut_res_lfo_increments[] PROGMEM;
extern const prog_uint8_t lut_res_curve_soft1[] PROGMEM;
extern const prog_uint8_t lut_res_curve_soft2[] PROGMEM;
extern const prog_uint8_t lut_res_curve_soft3[] PROGMEM;
extern const prog_uint8_t lut_res_curve_hard1[] PROGMEM;
extern const prog_uint8_t lut_res_curve_hard2[] PROGMEM;
extern const prog_uint8_t lut_res_curve_hard3[] PROGMEM;
extern const prog_uint8_t lut_res_curve_wide1[] PROGMEM;
extern const prog_uint8_t lut_res_curve_wide2[] PROGMEM;
extern const prog_uint8_t chr_res_custom_chars[] PROGMEM;
extern const prog_uint8_t wav_res_lfo_waveforms[] PROGMEM;
#define STR_RES_X 0  // x
#define LUT_RES_LFO_INCREMENTS 0
#define LUT_RES_LFO_INCREMENTS_SIZE 19
#define LUT_RES_CURVE_SOFT1 0
#define LUT_RES_CURVE_SOFT1_SIZE 128
#define LUT_RES_CURVE_SOFT2 1
#define LUT_RES_CURVE_SOFT2_SIZE 128
#define LUT_RES_CURVE_SOFT3 2
#define LUT_RES_CURVE_SOFT3_SIZE 128
#define LUT_RES_CURVE_HARD1 3
#define LUT_RES_CURVE_HARD1_SIZE 128
#define LUT_RES_CURVE_HARD2 4
#define LUT_RES_CURVE_HARD2_SIZE 128
#define LUT_RES_CURVE_HARD3 5
#define LUT_RES_CURVE_HARD3_SIZE 128
#define LUT_RES_CURVE_WIDE1 6
#define LUT_RES_CURVE_WIDE1_SIZE 128
#define LUT_RES_CURVE_WIDE2 7
#define LUT_RES_CURVE_WIDE2_SIZE 128
#define CHR_RES_CUSTOM_CHARS 0
#define CHR_RES_CUSTOM_CHARS_SIZE 32
#define WAV_RES_LFO_WAVEFORMS 0
#define WAV_RES_LFO_WAVEFORMS_SIZE 2193
typedef avrlib::ResourcesManager<
    ResourceId,
    avrlib::ResourcesTables<
        string_table,
        lookup_table_table> > ResourcesManager; 

}  // namespace midialf

#endif  // MIDIALF_RESOURCES_H_
