// Copyright 2015 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Stored slot interface.

#ifndef MIDIALF_SLOT_H_
#define MIDIALF_SLOT_H_

#include "midialf/midialf.h"
#include "midialf/song.h"
#include "midialf/seq.h"
#include "midialf/lfo.h"

namespace midialf {

struct SlotData {
  uint16_t size_;
  uint8_t name_[kNameLength];
  uint8_t channel_;
  uint8_t tempo_;
  uint8_t step_length_;
  int16_t swing_;
  uint8_t seq_root_note_;
  uint8_t seq_link_mode_;
  uint8_t seq_switch_mode_;
  uint8_t seq_transpose_mode_;
  uint8_t seq_direction_;
  uint8_t steps_forward_;
  uint8_t steps_backward_;
  uint8_t steps_replay_;
  uint8_t steps_interval_;
  uint8_t steps_repeat_;
  uint8_t steps_skip_;
  uint8_t cc1_number_;
  uint8_t cc2_number_;
  uint8_t prog_change_mode_;
  uint8_t ctrl_change_mode_;
  uint8_t clock_mode_;
  uint8_t bank_select_msb_;
  uint8_t bank_select_lsb_;
  uint8_t program_change_;
  uint16_t flags_;

  uint8_t cv_mode_[4];
  uint8_t gate_mode_[4];
  uint8_t strobe_width_;

  uint8_t reserved_[12];

  Seq seq_[kNumSeqs];

  Song song_;

  LfoSettings lfo_[kNumLfos];
  uint8_t lfo_resolution_;
};

class Slot : public SlotData {
 public:
  Slot() { size_ = sizeof(SlotData); }
  
  void Init();
  void Read(uint8_t slot);
  void Write(uint8_t slot);

  static void ReadName(uint8_t slot, uint8_t name[kNameLength]);

  void Validate();

private:
  static void ValidateName(uint8_t name[], uint8_t length);

};

}  // namespace midialf

#endif // MIDIALF_SLOT_H_
