// Copyright 2018 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Song model.

#include "midialf/midialf.h"
#include "midialf/song.h"

using namespace avrlib;

namespace midialf {

void Song::Step::Init() {
  seq = kDefSongSeq;
  play_count = kDefSongPlayCount;
  root_note = kDefSongRootNote;
}

#define FIX_DEF(name, Name) \
  if (name < kMin##Name || name > kMax##Name) { \
    name = kDef##Name; \
  }

void Song::Step::Validate() {
  FIX_DEF(seq, SongSeq)
  FIX_DEF(play_count, SongPlayCount)
  FIX_DEF(root_note, SongRootNote)
}

#undef FIX_DEF

void Song::Init() {
  step_[0].Init();
  for (uint8_t n = 1; n < kNumSteps; n++) {
    step_[n] = step_[0];
  }
}

void Song::Validate() {
  for (uint8_t n = 0; n < kNumSteps; n++) {
    step_[n].Validate();
  }
}

uint8_t Song::SelectNextStep(uint8_t& step) {
  for (uint8_t n = next_step(step); n != step; n = next_step(n)) {
    if (step_[n].play_count > 0) {
      step = n;
      return 1;
    }
  }

  return 0;
}

}  // midialf
