// Copyright 2018 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Song model.

#ifndef MIDIALF_SONG_H_
#define MIDIALF_SONG_H_

#include "midialf/midialf.h"

namespace midialf {
  
class Song {
public:

  Song() {}

  void Init();

  void Validate();

  struct Step {
    Step() {}

    void Init();
    void Validate();

    uint8_t seq:2;
    uint8_t play_count:6;
    uint8_t root_note;
  };

  // Accessors

  #define DEFINE_STEP_ACCESSORS(type, name) \
    type step_##name(uint8_t step) const { return step_[step].name; } \
    void set_step_##name(uint8_t step, uint8_t name) { step_[step].name = name; } 

  DEFINE_STEP_ACCESSORS(uint8_t, seq)
  DEFINE_STEP_ACCESSORS(uint8_t, play_count)
  DEFINE_STEP_ACCESSORS(uint8_t, root_note)

  #undef DEFINE_STEP_ACCESSORS

  inline uint8_t next_step(uint8_t step) {
    return ++step < kNumSteps ? step : 0;
  }

  uint8_t SelectNextStep(uint8_t& step);

private:
  Step step_[kNumSteps];

};

}  // namespace midialf

#endif // MIDIALF_SONG_H_
