// Copyright 2012 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// UI page for CCx/send editing

#ifndef MIDIALF_UI_PAGES_CC_PAGE_H_
#define MIDIALF_UI_PAGES_CC_PAGE_H_

#include "midialf/ui_pages/ui_page.h"

namespace midialf {

class CCPage : public UiPage {
 public:
  CCPage() { }
  
  static const uint8_t kNumCCs = 2;

  static void OnInit(PageInfo* pageInfo, UiPageIndex prevPage);
  static void OnQuit(UiPageIndex nextPage);
  
  static uint8_t OnIncrement(uint8_t id, int8_t value);
  static uint8_t OnClick(uint8_t id, uint8_t value);
  static uint8_t OnSwitch(uint8_t id, uint8_t value);
  static uint8_t OnIdle();

  static uint8_t UpdateScreen();
  static uint8_t UpdateLeds();
  
  static const prog_EventHandlers event_handlers_;

 private:
  static uint8_t cc_;

  static uint8_t view_seq_step_cc(uint8_t step);
  static void set_view_seq_step_cc(uint8_t step, uint8_t cc);
  
  static uint8_t view_seq_step_send_cc(uint8_t step);
  static void set_view_seq_step_send_cc(uint8_t step, uint8_t send_cc);
  
  DISALLOW_COPY_AND_ASSIGN(CCPage);
};

} // namespace midialf

#endif  // MIDIALF_UI_PAGES_CC_PAGE_H_
