// Copyright 2018 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Command page.

#ifndef MIDIALF_UI_PAGES_COMMAND_PAGE_H_
#define MIDIALF_UI_PAGES_COMMAND_PAGE_H_

#include "midialf/ui_pages/ui_page.h"

namespace midialf {

class CommandPage : public UiPage {
 public:
  CommandPage() { }
  
  static void OnInit(PageInfo* pageInfo, UiPageIndex prevPage);
  static void OnQuit(UiPageIndex nextPage);
  
  static uint8_t OnIncrement(uint8_t id, int8_t value);
  static uint8_t OnClick(uint8_t id, uint8_t value);
  static uint8_t OnSwitch(uint8_t id, uint8_t value);
  static uint8_t OnIdle();

  static uint8_t UpdateScreen();
  static uint8_t UpdateLeds();
  
  static const prog_EventHandlers event_handlers_;

 private:

   enum Commands {
    copySeq,
    rotateSeq,
    randomizeSeq,
    initializeSeq,
    sysexOneSlot,
    sysexAllSlots,
#ifdef ENABLE_CV_EXT
    sysexTuneData,
    tuneNoteCv,
#endif
    kNumCommands
  };

  static uint8_t command_;
  static uint32_t started_time_;
  static uint8_t scale_;
  static uint8_t slot_;

  static void DrawNotes(char* line);

  DISALLOW_COPY_AND_ASSIGN(CommandPage);
};

} // namespace midialf

#endif  // MIDIALF_UI_PAGES_COMMAND_PAGE_H_
