// Copyright 2018 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Configuration pages.

#ifndef MIDIALF_UI_PAGES_CONFIG_PAGE_H_
#define MIDIALF_UI_PAGES_CONFIG_PAGE_H_

#include "midialf/ui_pages/ui_page.h"

namespace midialf {

class ConfigPage : public UiPage {
 public:
  ConfigPage() { }
  
#ifdef ENABLE_CV_EXT
  static const uint8_t kNumPages = 5;
#else
  static const uint8_t kNumPages = 4;
#endif

  static void OnInit(PageInfo* pageInfo, UiPageIndex prevPage);
  static void OnQuit(UiPageIndex nextPage);
  
  static uint8_t OnIncrement(uint8_t id, int8_t value);
  static uint8_t OnClick(uint8_t id, uint8_t value);
  static uint8_t OnSwitch(uint8_t id, uint8_t value);
  static uint8_t OnIdle();

  static uint8_t UpdateScreen();
  static uint8_t UpdateLeds();
  
  static const prog_EventHandlers event_handlers_;

 private:
  static uint8_t page_;
  static uint8_t num_taps_;
  static uint32_t elapsed_time_;

  enum Learning {
    noLearning,
    learningChannel,
    learningSeqRootNote,
    learningCC1Number,
    learningCC2Number,
  };

  static uint8_t learning_;

  struct Prev {
    uint8_t step_length;
    int16_t swing;
    uint8_t seq_direction;
    uint8_t steps_forward;
    uint8_t steps_backward;
    uint8_t steps_replay;
    uint8_t steps_interval;
    uint8_t steps_repeat;
    uint8_t steps_skip;
    uint8_t prog_change_mode;
    uint8_t ctrl_change_mode;
#ifdef ENABLE_CV_EXT
    uint8_t strobe_width;
#endif
  };

  static Prev* prev_;

  static uint8_t HandlePage1_OnIncrement(uint8_t id, int8_t value);
  static uint8_t HandlePage2_OnIncrement(uint8_t id, int8_t value);
  static uint8_t HandlePage3_OnIncrement(uint8_t id, int8_t value);
  static uint8_t HandlePage4_OnIncrement(uint8_t id, int8_t value);
#ifdef ENABLE_CV_EXT
  static uint8_t HandlePage5_OnIncrement(uint8_t id, int8_t value);
#endif

  static uint8_t HandlePage1_OnSwitch(uint8_t id, uint8_t value);
  static uint8_t HandlePage2_OnSwitch(uint8_t id, uint8_t value);
  static uint8_t HandlePage3_OnSwitch(uint8_t id, uint8_t value);
  static uint8_t HandlePage4_OnSwitch(uint8_t id, uint8_t value);
#ifdef ENABLE_CV_EXT
  static uint8_t HandlePage5_OnSwitch(uint8_t id, uint8_t value);
#endif

  static void HandlePage1_UpdateScreen();
  static void HandlePage2_UpdateScreen();
  static void HandlePage3_UpdateScreen();
  static void HandlePage4_UpdateScreen();
#ifdef ENABLE_CV_EXT
  static void HandlePage5_UpdateScreen();
#endif

  static void InitPage();

  static void UpdateTapTempo();

  static void SetClockModeFlag(uint8_t flag, uint8_t value);
  static void SetNextClockOutput(uint8_t forward, uint8_t cycle);

  static uint8_t NoteCallback(uint8_t channel, uint8_t note, uint8_t velocity);
  static uint8_t ControlChangeCallback(uint8_t channel, uint8_t controller, uint8_t value);

  DISALLOW_COPY_AND_ASSIGN(ConfigPage);
};

} // namespace midialf

#endif  // MIDIALF_UI_PAGES_CONFIG_PAGE_H_
