// Copyright 2018 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Step configuration pages.

#ifndef MIDIALF_UI_PAGES_STEP_PAGE_H_
#define MIDIALF_UI_PAGES_STEP_PAGE_H_

#include "midialf/ui_pages/ui_page.h"

namespace midialf {

class StepPage : public UiPage {
 public:
  StepPage() { }
  
  static const uint8_t kNumPages = 3;

  static void OnInit(PageInfo* pageInfo, UiPageIndex prevPage);
  static void OnQuit(UiPageIndex nextPage);
  
  static uint8_t OnIncrement(uint8_t id, int8_t value);
  static uint8_t OnClick(uint8_t id, uint8_t value);
  static uint8_t OnSwitch(uint8_t id, uint8_t value);
  static uint8_t OnIdle();

  static uint8_t UpdateScreen();
  static uint8_t UpdateLeds();
  
  static const prog_EventHandlers event_handlers_;

  static void set_step(uint8_t step) {
    step_ = step;
  }

 private:
  static UiPageIndex prev_page_;
  static uint8_t page_;
  static uint8_t step_;

  struct Prev {
    uint8_t note;
    uint8_t velocity;
    uint8_t gate;
    uint8_t randomize_note;
    uint8_t randomize_note_scale;
    uint8_t randomize_velocity;
    uint8_t randomize_cc1;
    uint8_t randomize_cc2;
    uint8_t retrigger;
    uint8_t retrigger_velocity;
    uint8_t retrigger_transposition;
    uint8_t retrigger_transposition_scale;
  };

  static Prev* prev_;

  static uint32_t scale_selected_tick_;

  static uint8_t HandlePage1_OnIncrement(uint8_t id, int8_t value);
  static uint8_t HandlePage2_OnIncrement(uint8_t id, int8_t value);
  static uint8_t HandlePage3_OnIncrement(uint8_t id, int8_t value);

  static uint8_t HandlePage1_OnSwitch(uint8_t id, uint8_t value);
  static uint8_t HandlePage2_OnSwitch(uint8_t id, uint8_t value);
  static uint8_t HandlePage3_OnSwitch(uint8_t id, uint8_t value);

  static void HandlePage1_UpdateScreen();
  static void HandlePage2_UpdateScreen();
  static void HandlePage3_UpdateScreen();

  static void InitPage();

  DISALLOW_COPY_AND_ASSIGN(StepPage);
};

} // namespace midialf

#endif  // MIDIALF_UI_PAGES_STEP_PAGE_H_
