// Copyright 2014 Peter Kvitek.
//
// Author: Peter Kvitek (pete@kvitek.com)
//
// Based on Ambika code by Olivier Gillet (ol.gillet@gmail.com)
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// -----------------------------------------------------------------------------
//
// Base UI page class.

#ifndef MIDIALF_UI_PAGES_UI_PAGE_H_
#define MIDIALF_UI_PAGES_UI_PAGE_H_

#include "midialf/midialf.h"
#include "midialf/display.h"
#include "midialf/leds.h"
#include "midialf/dev.h"
#include "midialf/ui.h"

#include "avrlib/string.h"
#include "avrlib/clamp.h"

namespace midialf {

class UiPage {
 public:
  UiPage() { }

  static void OnInit(PageInfo* pageInfo, UiPageIndex prevPage);
  static void OnQuit(UiPageIndex nextPage);

  static uint8_t OnIncrement(uint8_t id, int8_t value);
  static uint8_t OnClick(uint8_t id, uint8_t value);
  static uint8_t OnSwitch(uint8_t id, uint8_t value);
  static uint8_t OnIdle();

  static uint8_t UpdateScreen();
  static uint8_t UpdateLeds();

  static const prog_EventHandlers event_handlers_;
  
 protected:

  static uint8_t cell_pos(uint8_t step);

  static void DrawSeparators();
  static void DrawSeparators(char* line);
  static void DrawStepIcons(char* line);

  static void DrawCells(char* line, const prog_char* cells);

  static void DrawSelStr2(char* buffer, uint8_t sel, const prog_char* strings);
  static void DrawSelStr4(char* buffer, uint8_t sel, const prog_char* strings);
  static void DrawSelStrN(char* buffer, uint8_t sel, const prog_char* strings, uint8_t width);

  static void DrawBrackets(char* buffer, uint8_t max_width);
  static void DrawDashes(char* buffer, uint8_t count);
  static void Draw2Dashes(char* buffer) { DrawDashes(buffer, 2); }

  static uint8_t FindLastSpace(char* str, uint8_t count);

  static const prog_char pchOffOn[] PROGMEM;

  DISALLOW_COPY_AND_ASSIGN(UiPage);
};

}  // namespace midialf

#endif  // MIDIALF_UI_PAGES_UI_PAGE_H_
